/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.TAY;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TAYTest {
    private Cpu6502 cpu;
    private TAY tay;

    @Before
    public void setUp() throws Exception {
        this.cpu = new Cpu6502();
        this.tay = new TAY();
    }

    @Test
    public void testTransferZero() throws EmulatorException {
        this.executeAndcheckTAY(0, 2);
    }

    @Test
    public void testTransferPositive() throws EmulatorException {
        this.executeAndcheckTAY(5, 0);
    }

    @Test
    public void testTransferNegative() throws EmulatorException {
        this.executeAndcheckTAY(129, 128);
    }

    private void executeAndcheckTAY(int target, int expected_flags) throws EmulatorException {
        this.cpu.setY(new HwByte(255L));
        this.cpu.setAccu(new HwByte((long)target));
        this.tay.execute(this.cpu, new NoOperand());
        Assert.assertEquals((long)target, (long)this.cpu.getY().getNumber());
        Assert.assertEquals((long)target, (long)this.cpu.getAccu().getNumber());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)this.cpu.getFlags());
    }
}

